/*
Tiempo en pasar entre dos barreras de luz
Modificado de anon90500195
https://forum.arduino.cc/t/medir-velocidad-entre-2-sensores-infrarrojos/932628/6
Con las conexiones de los sensores según 
http://fisicayarduino.robotica.ar/periodo-de-un-pendulo/
*/

int sensor1 = 12; //se define el fototransistor 1 en el pin 12
int sensor2 = 13; //se define el fototransistor 2 en el pin 13

unsigned long t1 = 0; //se define el tiempo al pasar por el primer sensor 
                      //y se le asigna de entrada el valor 0
unsigned long t2 = 0; //tiempo al pasar por el segundo sensor
unsigned long t12 = 0; 

void setup() {
  Serial.begin(9600);
  pinMode(sensor1,INPUT); //se define el sensor1 como de entrada
  pinMode(sensor2,INPUT);
}

void loop() {
  while(digitalRead(sensor1) == LOW); // espera que pase por el 1er sensor. Dejará de recibir luz infrarroja
  t1 = micros();  // guarda el tiempo en useg (microsegundos)
  while(digitalRead(sensor2) == LOW); // espera hasta que pase por el 2do sensor
  t2 = micros();
  //envia por el puerto serie los valores de t1, t2 y t12
  Serial.print("\nT1: ");
  Serial.print(t1);
  Serial.print("\nT2: ");
  Serial.print(t2);
  t12 = t2 - t1;
  Serial.print("\nTiempo total: ");
  Serial.print(t12);
  Serial.print(" useg");
}

