/* 
Registrar el período de oscilación de un péndulo
Esquema conexiones y código de 
http://fisicayarduino.robotica.ar/periodo-de-un-pendulo/  
*/

unsigned long startTime; //variable siempre positiva para tiempo
unsigned long actualTime;
unsigned long period1;
unsigned long period2;
boolean firstPass; //variable boleana: 0 o 1

void setup() {
  Serial.begin(9600);
  // pullup para evitar poner una resistencia externa
  pinMode(12,INPUT_PULLUP);  
  // comenzamos a tomar el tiempo en milisegundos      
  startTime = millis();
}

void loop() {
  // registramos los milisegundos
  actualTime = millis(); 
  // si se interrumpe la barrera
  if(pulseIn(12,HIGH)) {  
    // si pasa por primera vez
    if(firstPass) {        
      // guardamos la primera mitad del periodo
      period1 = actualTime - startTime; 
      firstPass = false;
    } else {
      // guardamos la segunda mitad del periodo
      period2 = actualTime - startTime;  
      // enviamos la suma por el puerto serie
      Serial.println(period1 + period2); 
      firstPass = true;
    }
    // reseteamos la variable temporal de comienzo 
    startTime = actualTime;  
  } 
}