/*
  Basat en la informació de la pàgina de Rui Santos
  https://RandomNerdTutorials.com/esp32-microsd-card-arduino/
  Dona permís per utilitzar la informació sempre que se'n faci referència 
*/
 
//El mòdul de la targeta microSD se comunica mitjançant el protocol de comunicació SPI. 
//Es pot connectar al ESP32 usant els pins SPI predeterminats:
//VCC a Vin (5v), CS a GPIO5, MOSI a GPIO23, CLK a GPIO18, MISO a GPIO19, TERRA a GND
// Llibreries per SD card. Pel esp32 venen de sèrie amb la biblioteca de la tarja esp32 d’Expressif 2.0 i amunt
#include "FS.h"
#include "SD.h"
#include <SPI.h>

//Connexions del sensor BME280: Vcc a 3,3V o 5V, GND a Gnd, SCL a SCL, SDA a SDA
//Llibreries pel sensor BME280
//La llibreria del sensor s'ha de baixar de
//https://github.com/Seeed-Studio/Grove_BME280
//Wire per I2C ja està inclosa de sèrie a l'IDE d'Arduino
#include "Seeed_BME280.h"
#include <Wire.h>
BME280 bme280;
 
// Variables que ha de llegir el sensor
float temp;
float hum;
float pres;
float tiempo; // Se define el tiempo como numero con decimales
float tiempoSegundos; // Se define el tiempo en segundos como número con decimales

String dataMessage;
 
// Initialize SD card
void initSDCard(){
   if (!SD.begin()) {
    Serial.println("Card Mount Failed");
    return;
  }
  uint8_t cardType = SD.cardType();
 
  if(cardType == CARD_NONE){
    Serial.println("No SD card attached");
    return;
  }
  Serial.print("SD Card Type: ");
  if(cardType == CARD_MMC){
    Serial.println("MMC");
  } else if(cardType == CARD_SD){
    Serial.println("SDSC");
  } else if(cardType == CARD_SDHC){
    Serial.println("SDHC");
  } else {
    Serial.println("UNKNOWN");
  }
  uint64_t cardSize = SD.cardSize() / (1024 * 1024);
  Serial.printf("SD Card Size: %lluMB\n", cardSize);
}
 
// Write to the SD card
void writeFile(fs::FS &fs, const char * path, const char * message) {
  Serial.printf("Writing file: %s\n", path);
 
  File file = fs.open(path, FILE_WRITE);
  if(!file) {
    Serial.println("Failed to open file for writing");
    return;
  }
  if(file.print(message)) {
    Serial.println("File written");
  } else {
    Serial.println("Write failed");
  }
  file.close();
}
 
// Append data to the SD card
void appendFile(fs::FS &fs, const char * path, const char * message) {
  Serial.printf("Appending to file: %s\n", path);
 
  File file = fs.open(path, FILE_APPEND);
  if(!file) {
    Serial.println("Failed to open file for appending");
    return;
  }
  if(file.print(message)) {
    Serial.println("Message appended");
  } else {
    Serial.println("Append failed");
  }
  file.close();
}
 
void setup() {
  Serial.begin(115200);
 
  if(!bme280.init()){
    Serial.println("Device error!");
  }
  tiempo = millis(); //mide el tiempo en milisegundos desde que se pone en marcha Arduino
  
  initSDCard();
   
  // If the data.txt file doesn't exist
  // Create a file on the SD card and write the data labels
  File file = SD.open("/data.txt");
  if(!file) {
    Serial.println("File doesn't exist");
    Serial.println("Creating file...");
    writeFile(SD, "/data.txt", "Epoch Time, Temperature, Humidity, Pressure \r\n");
  }
  else {
    Serial.println("File already exists");  
  }
  file.close();
}
 
void loop() {
 
    //Get sensor readings
    tiempo = millis(); //Actualiza el tiempo actual
    tiempoSegundos = tiempo/1000; //cambia los milisegundos a segundos
    temp = bme280.getTemperature();
    //temp = 1.8*bme280.getTemperature() + 32;
    hum = bme280.getHumidity();
    pres = bme280.getPressure()/100.0F;
    altitud = bme280.readAltitude (1013); // Ajustar con el valor local
 
    //Concatenate all info separated by commas
    dataMessage = String(tiempoSegundos) + ";" + String(temp) + ";" + String(hum) + ";" + String(pres) + String(altitud) "\r\n";
    Serial.print("Saving data: ");
    Serial.println(dataMessage);
 
    //Append the data to file
    appendFile(SD, "/data.txt", dataMessage.c_str());

//Informació redundant de les dades al port sèrie
    Serial.print("Tiempo(ms)=");
    Serial.print(tiempo);
    Serial.print(", Temperatura=");
    Serial.print(temp);
    Serial.print(", Humitat=");
    Serial.print(hum);
    Serial.print(", Pressio=");
    Serial.print(pres); 
    Serial.print(", Altitud=");
    Serial.println(altitud);     
  }
